﻿using System.Web.Mvc;
using System.Web.Configuration;

namespace HIPS.Web.Components.Cache
{
    /// <summary>
    /// Extends the MVC <see cref="OutputCacheAttribute"/> to support decoration of child actions for use with partial views.
    /// </summary>
    /// <remarks>
    /// Required because the standard MVC OutputCacheAttribute does not support being applied to child actions in controllers (using a cache profile defined in config).
    /// Refer to http://thenullreference.com/blog/fixing-the-asp-net-mvc-3-outputcacheattribute-for-partial-views-to-honor-some-web-config-settings/ (MVC 3, but doesn't appear to be fixed in MVC 4).
    /// </remarks>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="23 November 2013">Initial version.</change>
    /// </history>
    public class PartialOutputCacheAttribute : OutputCacheAttribute
    {
        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="cacheProfileName">Name of the output cache profile defined in the web.config file to be employed by the output cache.</param>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="23 November 2013">Initial version.</change>
        /// </history>
        public PartialOutputCacheAttribute(string cacheProfileName)
        {
            //Retrieve the relevant section from the configuration file.
            var cacheSection = (OutputCacheSettingsSection)WebConfigurationManager.GetSection("system.web/caching/outputCacheSettings");

            if (cacheSection != null)
            {
                //Retrieve the specified output cache profile from configuration.
                var cacheProfile = cacheSection.OutputCacheProfiles[cacheProfileName];

                if (cacheProfile != null)
                {
                    //Set the properties of the attribute based on the output cache profile settings in the configuration file.
                    this.Duration = cacheProfile.Duration;
                    this.VaryByParam = cacheProfile.VaryByParam;
                }
            }
        }

        #endregion

    }

}
